﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class FileInfoPanel
    Inherits FileSystemSample.FileSystemInfoBasePanel

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "The FileInfo class encapsulates attributes related to a file, such as its size, l" & _
            "ocation, and accessed time."
        '
        'FileInfoPanel
        '
        Me.Name = "FileInfoPanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As FileInfoPanel
    Friend WithEvents fileChooser As New FileChooser
    Private fInfo As FileInfo

    ''' <summary>
    ''' 获取此面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As FileInfoPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New FileInfoPanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并添加允许用户选择文件的控件。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub FileInfoPanel_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("file", FileChooser)
    End Sub

    ''' <summary>
    ''' 将该面板重置为其初始状态
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.GetFileInfo("
        FileChooser.AutoSize = True
        SetfileInfo()
    End Sub


    ''' <summary>
    ''' 根据用户输入填充这些控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        SetfileInfo()
    End Sub

    ''' <summary>
    ''' 为所选的文件创建 FileInfo 并用适当的值填充该 UI
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetfileInfo()
        If (Me.fileChooser.Filename <> String.Empty) Then
            fInfo = My.Computer.FileSystem.GetFileInfo(CType(Me.fileChooser.Filename, String))
            Me.nameLabel.Text = fInfo.Name
            Me.locationLabel.Text = fInfo.FullName
            Me.sizeLabel.Text = fInfo.Length.ToString
            Me.createdLabel.Text = fInfo.CreationTime.ToString
            Me.modifiedLabel.Text = fInfo.LastWriteTime.ToString
            Me.accessedLabel.Text = fInfo.LastWriteTime.ToString
            Me.readOnlyCheckBox.Checked = fInfo.IsReadOnly()
        Else
            Me.nameLabel.Text = String.Empty
            Me.locationLabel.Text = String.Empty
            Me.sizeLabel.Text = String.Empty
            Me.createdLabel.Text = String.Empty
            Me.modifiedLabel.Text = String.Empty
            Me.accessedLabel.Text = String.Empty
            Me.readOnlyCheckBox.Checked = False
        End If
    End Sub

    ''' <summary>
    ''' 将该面板重置为其初始状态。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

End Class
